function  ...
   [N, maxr, meanr, smallr, normmu, M2, auto, zero, jumps, angles] ...
    = SimpleStats(x,y)
% everything is in nanometers and microseconds
% N = number of points in the track
% maxr = largest jump in the track
% meanr = mean jump size
% smallr = % of jumps that are less than 5 nm (error in their expts was
% less than 30 nm, with gold tagged molecules, any data set with a large %
% of small jumps cannot satisfy their null hypothesis of having a Weibull
% distribution of the jump sizes because this distribution is zero for zero
% length jumps)
% normmu = % of jumps that are exactly zero (this can cause problems in
% some of the statistical tests)
% M2 = second moment of the lengths of jumps
%
% (x,y) are the coordinates of a path.
   N = length(x);
% Small jump cutoff
   cutoff = 5; % nm

% Compute the jumps and angles.
% r the size of the jump
% theta   Angle with respects to the x axis.
% zero is the number of zero jumps.
% small is the number of small jumps.
% 100 * smallr is the % of small jumps.
% maxr is the maximum jump size.
jumps = [];
angles = [];
small = 0;
zero = 0;
for n = 1:N-1;
   dx = x(n+1)-x(n);
   dy = y(n+1)-y(n);
   theta = atan2(dy,dx);
   angles = [angles,theta];
   r  = sqrt(dx^2+dy^2);
   jumps = [jumps,r];
   if r < cutoff
      small = small+1; 
   end
   if r == 0
      zero = zero+1;
   end
end
zero = zero/N;
smallr = small/N;
meanr = mean(jumps);
maxr = max(jumps);

% The mean jump.
mu = [x(N)-x(1),y(N)-y(1)]/(N-1);
% correo is a list of K autocorrelation coefficients.
correo = [];
K = 20;
for k = 0:K
   tmp = 0;
   for n = 1:N-k-1;
      dx1 = x(n+1)-x(n)-mu(1);
      dy1 = y(n+1)-y(n)-mu(2);
      dx2 = x(n+k+1)-x(n+k)-mu(1);
      dy2 = y(n+k+1)-y(n+k)-mu(2);
      dot = dx1*dx2+dy1*dy2;
      tmp = tmp + dot;
   end
   tmp = tmp/(N-k-1);
   correo = [correo, tmp];
end
% M2  is the second moment
M2 = correo(1);
normmu = norm(mu);
auto = correo(2:K)/M2;
